/*
 * Decompiled with CFR 0.152.
 */
package com.amap.adapter.util;

import com.amap.adapter.util.DisplayMetrics;

public class TypedValue {
    public static final int TYPE_NULL = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_ATTRIBUTE = 2;
    public static final int TYPE_STRING = 3;
    public static final int TYPE_FLOAT = 4;
    public static final int TYPE_DIMENSION = 5;
    public static final int TYPE_FRACTION = 6;
    public static final int TYPE_FIRST_INT = 16;
    public static final int TYPE_INT_DEC = 16;
    public static final int TYPE_INT_HEX = 17;
    public static final int TYPE_INT_BOOLEAN = 18;
    public static final int TYPE_FIRST_COLOR_INT = 28;
    public static final int TYPE_INT_COLOR_ARGB8 = 28;
    public static final int TYPE_INT_COLOR_RGB8 = 29;
    public static final int TYPE_INT_COLOR_ARGB4 = 30;
    public static final int TYPE_INT_COLOR_RGB4 = 31;
    public static final int TYPE_LAST_COLOR_INT = 31;
    public static final int TYPE_LAST_INT = 31;
    public static final int COMPLEX_UNIT_SHIFT = 0;
    public static final int COMPLEX_UNIT_MASK = 15;
    public static final int COMPLEX_UNIT_PX = 0;
    public static final int COMPLEX_UNIT_DIP = 1;
    public static final int COMPLEX_UNIT_SP = 2;
    public static final int COMPLEX_UNIT_PT = 3;
    public static final int COMPLEX_UNIT_IN = 4;
    public static final int COMPLEX_UNIT_MM = 5;
    public static final int COMPLEX_UNIT_FRACTION = 0;
    public static final int COMPLEX_UNIT_FRACTION_PARENT = 1;
    public static final int COMPLEX_RADIX_SHIFT = 4;
    public static final int COMPLEX_RADIX_MASK = 3;
    public static final int COMPLEX_RADIX_23p0 = 0;
    public static final int COMPLEX_RADIX_16p7 = 1;
    public static final int COMPLEX_RADIX_8p15 = 2;
    public static final int COMPLEX_RADIX_0p23 = 3;
    public static final int COMPLEX_MANTISSA_SHIFT = 8;
    public static final int COMPLEX_MANTISSA_MASK = 0xFFFFFF;
    public static final int DATA_NULL_UNDEFINED = 0;
    public static final int DATA_NULL_EMPTY = 1;
    public static final int DENSITY_DEFAULT = 0;
    public static final int DENSITY_NONE = 65535;
    public int type;
    public CharSequence string;
    public int data;
    public int assetCookie;
    public int resourceId;
    public int changingConfigurations = -1;
    public int density;
    private static final float MANTISSA_MULT = 0.00390625f;
    private static final float[] RADIX_MULTS = new float[]{0.00390625f, 3.0517578E-5f, 1.1920929E-7f, 4.656613E-10f};
    private static final String[] DIMENSION_UNIT_STRS = new String[]{"px", "dip", "sp", "pt", "in", "mm"};
    private static final String[] FRACTION_UNIT_STRS = new String[]{"%", "%p"};

    public final float getFloat() {
        return Float.intBitsToFloat(this.data);
    }

    public static float complexToFloat(int n2) {
        return (float)(n2 & 0xFFFFFF00) * RADIX_MULTS[n2 >> 4 & 3];
    }

    public static float complexToDimension(int n2, DisplayMetrics displayMetrics) {
        return TypedValue.applyDimension(n2 >> 0 & 0xF, TypedValue.complexToFloat(n2), displayMetrics);
    }

    public static int complexToDimensionPixelOffset(int n2, DisplayMetrics displayMetrics) {
        return (int)TypedValue.applyDimension(n2 >> 0 & 0xF, TypedValue.complexToFloat(n2), displayMetrics);
    }

    public static int complexToDimensionPixelSize(int n2, DisplayMetrics displayMetrics) {
        float f2 = TypedValue.complexToFloat(n2);
        float f3 = TypedValue.applyDimension(n2 >> 0 & 0xF, f2, displayMetrics);
        int n3 = (int)(f3 >= 0.0f ? f3 + 0.5f : f3 - 0.5f);
        if (n3 != 0) {
            return n3;
        }
        if (f2 == 0.0f) {
            return 0;
        }
        if (f2 > 0.0f) {
            return 1;
        }
        return -1;
    }

    @Deprecated
    public static float complexToDimensionNoisy(int n2, DisplayMetrics displayMetrics) {
        return TypedValue.complexToDimension(n2, displayMetrics);
    }

    public int getComplexUnit() {
        return 0xF & this.data >> 0;
    }

    public static float applyDimension(int n2, float f2, DisplayMetrics displayMetrics) {
        switch (n2) {
            case 0: {
                return f2;
            }
            case 1: {
                return f2 * displayMetrics.density;
            }
            case 2: {
                return f2 * displayMetrics.scaledDensity;
            }
            case 3: {
                return f2 * displayMetrics.xdpi * 0.013888889f;
            }
            case 4: {
                return f2 * displayMetrics.xdpi;
            }
            case 5: {
                return f2 * displayMetrics.xdpi * 0.03937008f;
            }
        }
        return 0.0f;
    }

    public float getDimension(DisplayMetrics displayMetrics) {
        return TypedValue.complexToDimension(this.data, displayMetrics);
    }

    public static float complexToFraction(int n2, float f2, float f3) {
        switch (n2 >> 0 & 0xF) {
            case 0: {
                return TypedValue.complexToFloat(n2) * f2;
            }
            case 1: {
                return TypedValue.complexToFloat(n2) * f3;
            }
        }
        return 0.0f;
    }

    public float getFraction(float f2, float f3) {
        return TypedValue.complexToFraction(this.data, f2, f3);
    }

    public final CharSequence coerceToString() {
        int n2 = this.type;
        if (n2 == 3) {
            return this.string;
        }
        return TypedValue.coerceToString(n2, this.data);
    }

    public static final String coerceToString(int n2, int n3) {
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return "@" + n3;
            }
            case 2: {
                return "?" + n3;
            }
            case 4: {
                return Float.toString(Float.intBitsToFloat(n3));
            }
            case 5: {
                return Float.toString(TypedValue.complexToFloat(n3)) + DIMENSION_UNIT_STRS[n3 >> 0 & 0xF];
            }
            case 6: {
                return Float.toString(TypedValue.complexToFloat(n3) * 100.0f) + FRACTION_UNIT_STRS[n3 >> 0 & 0xF];
            }
            case 17: {
                return "0x" + Integer.toHexString(n3);
            }
            case 18: {
                return n3 != 0 ? "true" : "false";
            }
        }
        if (n2 >= 28 && n2 <= 31) {
            return "#" + Integer.toHexString(n3);
        }
        if (n2 >= 16 && n2 <= 31) {
            return Integer.toString(n3);
        }
        return null;
    }

    public void setTo(TypedValue typedValue) {
        this.type = typedValue.type;
        this.string = typedValue.string;
        this.data = typedValue.data;
        this.assetCookie = typedValue.assetCookie;
        this.resourceId = typedValue.resourceId;
        this.density = typedValue.density;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TypedValue{t=0x").append(Integer.toHexString(this.type));
        stringBuilder.append("/d=0x").append(Integer.toHexString(this.data));
        if (this.type == 3) {
            stringBuilder.append(" \"").append(this.string != null ? this.string : "<null>").append("\"");
        }
        if (this.assetCookie != 0) {
            stringBuilder.append(" a=").append(this.assetCookie);
        }
        if (this.resourceId != 0) {
            stringBuilder.append(" r=0x").append(Integer.toHexString(this.resourceId));
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }
}

