/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.mapcore.util;

import com.amap.adapter.content.Context;
import com.amap.adapter.content.res.AssetManager;
import com.amap.adapter.graphics.Bitmap;
import com.amap.adapter.graphics.BitmapFactory;
import com.amap.adapter.graphics.Point;
import com.amap.adapter.graphics.Rect;
import com.amap.adapter.graphics.drawable.Drawable;
import com.amap.adapter.net.ConnectivityManager;
import com.amap.adapter.net.NetworkInfo;
import com.amap.adapter.net.Uri;
import com.amap.adapter.opengl.GLES20;
import com.amap.adapter.opengl.GLUtils;
import com.amap.adapter.os.Build;
import com.amap.adapter.os.RemoteException;
import com.amap.adapter.text.TextUtils;
import com.amap.adapter.util.Log;
import com.amap.adapter.util.Pair;
import com.amap.adapter.view.View;
import com.amap.adapter.view.ViewGroup;
import com.amap.adapter.widget.TextView;
import com.amap.api.mapcore.util.em;
import com.amap.api.mapcore.util.en;
import com.amap.api.mapcore.util.gi;
import com.amap.api.mapcore.util.hd;
import com.amap.api.mapcore.util.l;
import com.amap.api.maps.AMapUtils;
import com.amap.api.maps.MapsInitializer;
import com.amap.api.maps.model.BaseHoleOptions;
import com.amap.api.maps.model.CircleHoleOptions;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.LatLngBounds;
import com.amap.api.maps.model.PolygonHoleOptions;
import com.amap.api.maps.utils.SpatialRelationUtil;
import com.autonavi.amap.api.mapcore.IGLMapState;
import com.autonavi.amap.mapcore.AbstractCameraUpdateMessage;
import com.autonavi.amap.mapcore.DPoint;
import com.autonavi.amap.mapcore.IPoint;
import com.autonavi.amap.mapcore.VirtualEarthProjection;
import com.autonavi.amap.mapcore.interfaces.IMapConfig;
import com.autonavi.base.amap.api.mapcore.IAMapDelegate;
import com.autonavi.base.amap.mapcore.FPoint;
import com.autonavi.base.amap.mapcore.FPoint3;
import com.autonavi.base.amap.mapcore.FileUtil;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class es {
    private static FPoint[] a = new FPoint[]{FPoint.obtain(), FPoint.obtain(), FPoint.obtain(), FPoint.obtain()};
    private static List<Float> b = new ArrayList<Float>(4);
    private static List<Float> c = new ArrayList<Float>(4);

    public static Bitmap a(Context context, String string) {
        try {
            AssetManager assetManager = em.a(context);
            InputStream inputStream = assetManager.open(string);
            Bitmap bitmap = BitmapFactory.decodeStream(inputStream);
            inputStream.close();
            return bitmap;
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "fromAsset");
            es.a(throwable);
            return null;
        }
    }

    public static void a(Drawable drawable) {
        if (drawable != null) {
            drawable.setCallback(null);
            drawable = null;
        }
    }

    public static String a(String string, Object object) {
        return string + "=" + String.valueOf(object);
    }

    public static float a(IMapConfig iMapConfig, float f2, float f3) {
        int n2;
        boolean bl2 = false;
        boolean bl3 = false;
        if (iMapConfig != null) {
            bl2 = iMapConfig.isAbroadEnable();
            bl3 = iMapConfig.getAbroadState() != 1;
        }
        float f4 = f2;
        if (bl2) {
            n2 = 0;
            if (bl3) {
                n2 = 40;
                f4 = f4 > (float)n2 ? (float)n2 : f4;
                return f4;
            }
        }
        if (f2 > 40.0f) {
            n2 = 0;
            n2 = f3 <= 15.0f ? 40 : (f3 <= 16.0f ? 56 : (f3 <= 17.0f ? 66 : (f3 <= 18.0f ? 74 : (f3 <= 18.0f ? 78 : 80))));
            f4 = f4 > (float)n2 ? (float)n2 : f4;
        }
        return f4;
    }

    public static float a(IMapConfig iMapConfig, float f2) {
        if (iMapConfig != null) {
            if (f2 > iMapConfig.getMaxZoomLevel()) {
                f2 = iMapConfig.getMaxZoomLevel();
            } else if (f2 < iMapConfig.getMinZoomLevel()) {
                f2 = iMapConfig.getMinZoomLevel();
            }
        } else if (f2 > 20.0f) {
            f2 = 20.0f;
        } else if (f2 < 3.0f) {
            f2 = 3.0f;
        }
        return f2;
    }

    public static FloatBuffer a(float[] fArray) {
        try {
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(fArray.length * 4);
            byteBuffer.order(ByteOrder.nativeOrder());
            FloatBuffer floatBuffer = byteBuffer.asFloatBuffer();
            floatBuffer.put(fArray);
            floatBuffer.position(0);
            return floatBuffer;
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "makeFloatBuffer1");
            throwable.printStackTrace();
            return null;
        }
    }

    public static FloatBuffer a(float[] fArray, FloatBuffer floatBuffer) {
        try {
            floatBuffer.clear();
            floatBuffer.put(fArray);
            floatBuffer.position(0);
            return floatBuffer;
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "makeFloatBuffer2");
            throwable.printStackTrace();
            return null;
        }
    }

    public static int a(int n2, int n3) {
        Bitmap bitmap = Bitmap.createBitmap(n2, n3, Bitmap.Config.ARGB_8888);
        return es.a(0, bitmap, true);
    }

    public static int a(Bitmap bitmap) {
        return es.a(bitmap, false);
    }

    public static int a(Bitmap bitmap, boolean bl2) {
        return es.a(0, bitmap, bl2);
    }

    public static int a(int n2, Bitmap bitmap, boolean bl2) {
        n2 = es.b(n2, bitmap, bl2);
        es.b(bitmap);
        return n2;
    }

    public static int b(int n2, Bitmap bitmap, boolean bl2) {
        if (bitmap == null || bitmap.isRecycled()) {
            return 0;
        }
        if (n2 == 0) {
            int[] nArray = new int[]{0};
            GLES20.glGenTextures(1, nArray, 0);
            n2 = nArray[0];
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        if (bl2) {
            GLES20.glTexParameterf((int)3553, (int)10242, (float)10497.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)10497.0f);
        } else {
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
        }
        GLUtils.texImage2D(3553, 0, bitmap, 0);
        return n2;
    }

    public static int a(int n2, Bitmap bitmap, int n3, int n4) {
        if (bitmap == null || bitmap.isRecycled()) {
            return 0;
        }
        if (n2 == 0) {
            int[] nArray = new int[]{0};
            GLES20.glGenTextures(1, nArray, 0);
            n2 = nArray[0];
        }
        GLES20.glActiveTexture((int)33984);
        GLES20.glBindTexture((int)3553, (int)n2);
        GLUtils.texSubImage2D(3553, 0, n3, n4, bitmap);
        return n2;
    }

    public static String a(String ... stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        for (String string : stringArray) {
            stringBuilder.append(string);
            if (n2 != stringArray.length - 1) {
                stringBuilder.append(",");
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    public static int a(Object[] objectArray) {
        return Arrays.hashCode(objectArray);
    }

    public static Bitmap a(Bitmap bitmap, float f2) {
        if (bitmap == null) {
            return null;
        }
        int n2 = (int)((float)bitmap.getWidth() * f2);
        int n3 = (int)((float)bitmap.getHeight() * f2);
        Bitmap bitmap2 = Bitmap.createScaledBitmap(bitmap, n2, n3, true);
        return bitmap2;
    }

    public static String a(Context context) {
        String string;
        File file;
        File file2 = new File(FileUtil.getMapBaseStorage(context), "data_v6");
        if (!file2.exists()) {
            file2.mkdir();
        }
        if (!(file = new File(string = file2.toString() + File.separator)).exists()) {
            file.mkdir();
        }
        return file2.toString() + File.separator;
    }

    public static String b(Context context) {
        return FileUtil.getMapBaseStorage(context) + File.separator + "data" + File.separator;
    }

    public static String c(Context context) {
        String string = es.a(context);
        if (string == null) {
            return null;
        }
        File file = new File(string, "VMAP2");
        if (!file.exists()) {
            file.mkdir();
        }
        return file.toString() + File.separator;
    }

    public static String a(int n2) {
        String string = n2 < 1000 ? n2 + "m" : n2 / 1000 + "km";
        return string;
    }

    public static boolean d(Context context) {
        if (context == null) {
            return false;
        }
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return false;
        }
        NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
        if (networkInfo == null) {
            return false;
        }
        NetworkInfo.State state = networkInfo.getState();
        return state != null && state != NetworkInfo.State.DISCONNECTED && state != NetworkInfo.State.DISCONNECTING;
    }

    public static boolean a() {
        return Build.VERSION.SDK_INT >= 0;
    }

    public static boolean b() {
        return Build.VERSION.SDK_INT >= 0;
    }

    public static boolean c() {
        return Build.VERSION.SDK_INT >= 0;
    }

    public static boolean d() {
        return Build.VERSION.SDK_INT >= 0;
    }

    public static void b(int n2) {
        GLES20.glDeleteTextures(1, new int[]{n2}, 0);
    }

    public static String a(InputStream inputStream) {
        String string = null;
        try {
            string = new String(es.b(inputStream), "utf-8");
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "decodeAssetResData");
            throwable.printStackTrace();
        }
        return string;
    }

    public static byte[] b(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[2048];
        int n2 = -1;
        while ((n2 = inputStream.read(byArray, 0, 2048)) != -1) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byArray = null;
        return byteArrayOutputStream.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String a(File file) {
        StringBuffer stringBuffer = new StringBuffer();
        FileInputStream fileInputStream = null;
        BufferedReader bufferedReader = null;
        try {
            fileInputStream = new FileInputStream(file);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf-8"));
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }
        catch (FileNotFoundException fileNotFoundException) {
            hd.c(fileNotFoundException, "Util", "readFile fileNotFound");
            fileNotFoundException.printStackTrace();
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            hd.c(iOException, "Util", "readFile io");
            iOException.printStackTrace();
            return stringBuffer.toString();
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean a(LatLng latLng, List<LatLng> list) {
        if (latLng == null || list == null) {
            return false;
        }
        boolean bl2 = false;
        int n2 = 0;
        double d2 = 180.0;
        double d3 = latLng.longitude;
        double d4 = latLng.latitude;
        double d5 = latLng.latitude;
        if (list.size() < 3) {
            return false;
        }
        boolean bl3 = false;
        if (!list.get(0).equals(list.get(list.size() - 1))) {
            list.add(list.get(0));
            bl3 = true;
        }
        try {
            for (int i2 = 0; i2 < list.size() - 1; ++i2) {
                double d6 = list.get((int)i2).longitude;
                double d7 = list.get((int)i2).latitude;
                double d8 = list.get((int)(i2 + 1)).longitude;
                double d9 = list.get((int)(i2 + 1)).latitude;
                if (es.b(d3, d4, d6, d7, d8, d9)) {
                    boolean bl4 = true;
                    return bl4;
                }
                if (Math.abs(d9 - d7) < 1.0E-9) continue;
                if (es.b(d6, d7, d3, d4, d2, d5)) {
                    if (!(d7 > d9)) continue;
                    ++n2;
                    continue;
                }
                if (es.b(d8, d9, d3, d4, d2, d5)) {
                    if (!(d9 > d7)) continue;
                    ++n2;
                    continue;
                }
                if (!es.a(d6, d7, d8, d9, d3, d4, d2, d5)) continue;
                ++n2;
            }
            if (n2 % 2 != 0) {
                bl2 = true;
            }
        }
        finally {
            if (bl3) {
                list.remove(list.size() - 1);
            }
        }
        return bl2;
    }

    public static double a(double d2, double d3, double d4, double d5, double d6, double d7) {
        return (d4 - d2) * (d7 - d3) - (d6 - d2) * (d5 - d3);
    }

    public static boolean b(double d2, double d3, double d4, double d5, double d6, double d7) {
        boolean bl2 = false;
        if (Math.abs(es.a(d2, d3, d4, d5, d6, d7)) < 1.0E-9 && (d2 - d4) * (d2 - d6) <= 0.0 && (d3 - d5) * (d3 - d7) <= 0.0) {
            bl2 = true;
        }
        return bl2;
    }

    public static boolean a(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        boolean bl2 = false;
        double d10 = (d4 - d2) * (d9 - d7) - (d5 - d3) * (d8 - d6);
        if (d10 != 0.0) {
            double d11 = ((d3 - d7) * (d8 - d6) - (d2 - d6) * (d9 - d7)) / d10;
            double d12 = ((d3 - d7) * (d4 - d2) - (d2 - d6) * (d5 - d3)) / d10;
            if (d11 >= 0.0 && d11 <= 1.0 && d12 >= 0.0 && d12 <= 1.0) {
                bl2 = true;
            }
        }
        return bl2;
    }

    public static boolean a(BaseHoleOptions baseHoleOptions, LatLng latLng) {
        if (baseHoleOptions instanceof CircleHoleOptions) {
            CircleHoleOptions circleHoleOptions = (CircleHoleOptions)baseHoleOptions;
            LatLng latLng2 = circleHoleOptions.getCenter();
            double d2 = circleHoleOptions.getRadius();
            if (latLng2 == null) {
                return false;
            }
            return (double)AMapUtils.calculateLineDistance(latLng2, latLng) <= d2;
        }
        PolygonHoleOptions polygonHoleOptions = (PolygonHoleOptions)baseHoleOptions;
        List<LatLng> list = polygonHoleOptions.getPoints();
        if (list == null || list.size() == 0) {
            return false;
        }
        return es.a(latLng, list);
    }

    public static List<FPoint> a(FPoint[] fPointArray, List<FPoint> list, boolean bl2) {
        ArrayList<FPoint> arrayList = new ArrayList<FPoint>();
        ArrayList<FPoint> arrayList2 = new ArrayList<FPoint>(list);
        for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            int n3;
            arrayList.clear();
            int n4 = arrayList2.size();
            for (n3 = 0; n3 < (bl2 ? n4 : n4 - 1); ++n3) {
                FPoint fPoint = (FPoint)arrayList2.get(n3 % n4);
                FPoint fPoint2 = (FPoint)arrayList2.get((n3 + 1) % n4);
                if (n3 == 0 && es.a(fPoint, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    arrayList.add(fPoint);
                }
                if (es.a(fPoint, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    if (es.a(fPoint2, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                        arrayList.add(fPoint2);
                        continue;
                    }
                    arrayList.add(es.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint, fPoint2));
                    continue;
                }
                if (!es.a(fPoint2, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) continue;
                arrayList.add(es.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint, fPoint2));
                arrayList.add(fPoint2);
            }
            arrayList2.clear();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList2.add((FPoint)arrayList.get(n3));
            }
        }
        return arrayList2;
    }

    public static List<FPoint> b(FPoint[] fPointArray, List<FPoint> list, boolean bl2) {
        ArrayList<FPoint3> arrayList = new ArrayList<FPoint3>();
        ArrayList<FPoint> arrayList2 = new ArrayList<FPoint>(list);
        for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            int n3;
            arrayList.clear();
            int n4 = arrayList2.size();
            for (n3 = 0; n3 < (bl2 ? n4 : n4 - 1); ++n3) {
                FPoint3 fPoint3 = (FPoint3)arrayList2.get(n3 % n4);
                FPoint3 fPoint32 = (FPoint3)arrayList2.get((n3 + 1) % n4);
                if (n3 == 0 && es.a(fPoint3, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    arrayList.add(fPoint3);
                }
                if (es.a(fPoint3, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                    if (es.a(fPoint32, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) {
                        arrayList.add(fPoint32);
                        continue;
                    }
                    arrayList.add(es.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint3, fPoint32, fPoint32.colorIndex));
                    continue;
                }
                if (!es.a(fPoint32, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) continue;
                arrayList.add(es.a(fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length], fPoint3, fPoint32, fPoint3.colorIndex));
                arrayList.add(fPoint32);
            }
            arrayList2.clear();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList2.add((FPoint)arrayList.get(n3));
            }
        }
        return arrayList2;
    }

    public static FPoint[] a(IAMapDelegate iAMapDelegate, boolean bl2) {
        float f2 = iAMapDelegate.getSkyHeight();
        int n2 = 0;
        int n3 = 0;
        if (bl2) {
            n2 = 100;
            n3 = 10;
        }
        FPoint fPoint = FPoint.obtain();
        iAMapDelegate.pixel2Map(-n2, (int)(f2 - (float)n3), fPoint);
        a[0].set(fPoint.x, fPoint.y);
        FPoint fPoint2 = FPoint.obtain();
        iAMapDelegate.pixel2Map(iAMapDelegate.getMapWidth() + n2, (int)(f2 - (float)n3), fPoint2);
        a[1].set(fPoint2.x, fPoint2.y);
        FPoint fPoint3 = FPoint.obtain();
        iAMapDelegate.pixel2Map(iAMapDelegate.getMapWidth() + n2, iAMapDelegate.getMapHeight() + n2, fPoint3);
        a[2].set(fPoint3.x, fPoint3.y);
        FPoint fPoint4 = FPoint.obtain();
        iAMapDelegate.pixel2Map(-n2, iAMapDelegate.getMapHeight() + n2, fPoint4);
        a[3].set(fPoint4.x, fPoint4.y);
        fPoint.recycle();
        fPoint2.recycle();
        fPoint3.recycle();
        fPoint4.recycle();
        return a;
    }

    private static FPoint3 a(FPoint fPoint, FPoint fPoint2, FPoint3 fPoint3, FPoint3 fPoint32, int n2) {
        FPoint3 fPoint33 = new FPoint3(0.0f, 0.0f, n2);
        double d2 = (fPoint2.y - fPoint.y) * (fPoint.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint.y - fPoint3.y);
        double d3 = (fPoint2.y - fPoint.y) * (fPoint32.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint32.y - fPoint3.y);
        fPoint33.x = (float)((double)fPoint3.x + (double)(fPoint32.x - fPoint3.x) * d2 / d3);
        fPoint33.y = (float)((double)fPoint3.y + (double)(fPoint32.y - fPoint3.y) * d2 / d3);
        return fPoint33;
    }

    private static FPoint a(FPoint fPoint, FPoint fPoint2, FPoint fPoint3, FPoint fPoint4) {
        FPoint fPoint5 = FPoint.obtain(0.0f, 0.0f);
        double d2 = (fPoint2.y - fPoint.y) * (fPoint.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint.y - fPoint3.y);
        double d3 = (fPoint2.y - fPoint.y) * (fPoint4.x - fPoint3.x) - (fPoint2.x - fPoint.x) * (fPoint4.y - fPoint3.y);
        fPoint5.x = (float)((double)fPoint3.x + (double)(fPoint4.x - fPoint3.x) * d2 / d3);
        fPoint5.y = (float)((double)fPoint3.y + (double)(fPoint4.y - fPoint3.y) * d2 / d3);
        return fPoint5;
    }

    public static boolean a(FPoint fPoint, FPoint[] fPointArray) {
        if (fPointArray == null) {
            return false;
        }
        for (int n2 = 0; n2 < fPointArray.length; n2 = (int)((byte)(n2 + 1))) {
            if (es.a(fPoint, fPointArray[n2], fPointArray[(n2 + 1) % fPointArray.length])) continue;
            return false;
        }
        return true;
    }

    private static boolean a(FPoint fPoint, FPoint fPoint2, FPoint fPoint3) {
        double d2 = (fPoint3.x - fPoint2.x) * (fPoint.y - fPoint2.y) - (fPoint.x - fPoint2.x) * (fPoint3.y - fPoint2.y);
        return d2 >= 0.0;
    }

    public static List<IPoint> a(IPoint[] iPointArray, List<IPoint> list, boolean bl2) {
        ArrayList<IPoint> arrayList = new ArrayList<IPoint>();
        ArrayList<IPoint> arrayList2 = new ArrayList<IPoint>(list);
        for (int n2 = 0; n2 < 4; n2 = (int)((byte)(n2 + 1))) {
            int n3;
            arrayList.clear();
            int n4 = arrayList2.size();
            for (n3 = 0; n3 < (bl2 ? n4 : n4 - 1); ++n3) {
                IPoint iPoint = (IPoint)arrayList2.get(n3 % n4);
                IPoint iPoint2 = (IPoint)arrayList2.get((n3 + 1) % n4);
                if (n3 == 0 && es.a(iPoint, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) {
                    arrayList.add(iPoint);
                }
                if (es.a(iPoint, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) {
                    if (es.a(iPoint2, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) {
                        arrayList.add(iPoint2);
                        continue;
                    }
                    arrayList.add(es.a(iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length], iPoint, iPoint2));
                    continue;
                }
                if (!es.a(iPoint2, iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length])) continue;
                arrayList.add(es.a(iPointArray[n2], iPointArray[(n2 + 1) % iPointArray.length], iPoint, iPoint2));
                arrayList.add(iPoint2);
            }
            arrayList2.clear();
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                arrayList2.add((IPoint)arrayList.get(n3));
            }
        }
        return arrayList2;
    }

    private static IPoint a(IPoint iPoint, IPoint iPoint2, IPoint iPoint3, IPoint iPoint4) {
        IPoint iPoint5 = IPoint.obtain(0, 0);
        double d2 = (double)(iPoint2.y - iPoint.y) * (double)(iPoint.x - iPoint3.x) - (double)(iPoint2.x - iPoint.x) * (double)(iPoint.y - iPoint3.y);
        double d3 = (double)(iPoint2.y - iPoint.y) * (double)(iPoint4.x - iPoint3.x) - (double)(iPoint2.x - iPoint.x) * (double)(iPoint4.y - iPoint3.y);
        iPoint5.x = (int)((double)iPoint3.x + (double)(iPoint4.x - iPoint3.x) * d2 / d3);
        iPoint5.y = (int)((double)iPoint3.y + (double)(iPoint4.y - iPoint3.y) * d2 / d3);
        return iPoint5;
    }

    public static boolean a(List<IPoint> list, int n2, int n3) {
        if (n3 < 3) {
            return false;
        }
        double d2 = 1000000.0;
        double d3 = 0.0;
        int n4 = n3 - 1;
        int n5 = 0;
        while (n5 < n3) {
            IPoint iPoint = list.get(n4);
            IPoint iPoint2 = list.get(n5);
            d3 += (double)iPoint.x / d2 * ((double)iPoint2.y / d2) - (double)iPoint2.x / d2 * ((double)iPoint.y / d2);
            n4 = n5++;
        }
        return d3 < 0.0;
    }

    private static boolean a(IPoint iPoint, IPoint iPoint2, IPoint iPoint3) {
        return es.a(iPoint.x, iPoint.y, iPoint2, iPoint3);
    }

    private static boolean a(int n2, int n3, IPoint iPoint, IPoint iPoint2) {
        double d2 = iPoint2.x - iPoint.x;
        double d3 = n3 - iPoint.y;
        double d4 = n2 - iPoint.x;
        double d5 = iPoint2.y - iPoint.y;
        return d2 * d3 - d4 * d5 >= 0.0;
    }

    public static gi e() {
        try {
            if (l.e == null) {
                l.e = new gi.a("3dmap", "7.9.2", l.c).a(new String[]{"com.amap.api.maps", "com.amap.api.mapcore", "com.autonavi.amap.mapcore", "com.autonavi.amap", "com.autonavi.ae", "com.autonavi.base", "com.autonavi.patch", "com.amap.api.3dmap.admic", "com.amap.api.trace", "com.amap.api.trace.core"}).a("7.9.2").a();
            }
        }
        catch (Throwable throwable) {
            return null;
        }
        return l.e;
    }

    private static void c(View view) {
        if (view instanceof ViewGroup) {
            for (int i2 = 0; i2 < ((ViewGroup)view).getChildCount(); ++i2) {
                es.c(((ViewGroup)view).getChildAt(i2));
            }
        } else if (view instanceof TextView) {
            ((TextView)view).setHorizontallyScrolling(false);
        }
    }

    public static Bitmap a(View view) {
        try {
            es.c(view);
            view.destroyDrawingCache();
            view.measure(View.MeasureSpec.makeMeasureSpec(0, 0), View.MeasureSpec.makeMeasureSpec(0, 0));
            view.layout(0, 0, view.getMeasuredWidth(), view.getMeasuredHeight());
            Bitmap bitmap = view.getDrawingCache();
            if (bitmap != null) {
                return bitmap.copy(Bitmap.Config.ARGB_8888, false);
            }
            return null;
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Utils", "getBitmapFromView");
            throwable.printStackTrace();
            return null;
        }
    }

    public static DPoint a(LatLng latLng) {
        double d2 = latLng.longitude / 360.0 + 0.5;
        double d3 = Math.sin(Math.toRadians(latLng.latitude));
        double d4 = 0.5 * Math.log((1.0 + d3) / (1.0 - d3)) / (Math.PI * -2) + 0.5;
        return DPoint.obtain(d2 * 1.0, d4 * 1.0);
    }

    public static boolean a(Rect rect, int n2, int n3) {
        return rect.contains(n2, n3);
    }

    public static Pair<Float, IPoint> a(AbstractCameraUpdateMessage abstractCameraUpdateMessage, IGLMapState iGLMapState, IMapConfig iMapConfig) {
        LatLngBounds latLngBounds = abstractCameraUpdateMessage.bounds;
        int n2 = abstractCameraUpdateMessage.width;
        int n3 = abstractCameraUpdateMessage.height;
        int n4 = Math.max(abstractCameraUpdateMessage.paddingLeft, 1);
        int n5 = Math.max(abstractCameraUpdateMessage.paddingRight, 1);
        int n6 = Math.max(abstractCameraUpdateMessage.paddingTop, 1);
        int n7 = Math.max(abstractCameraUpdateMessage.paddingBottom, 1);
        return es.a(iMapConfig, n4, n5, n6, n7, latLngBounds, n2, n3);
    }

    public static Pair<Float, IPoint> a(IMapConfig iMapConfig, int n2, int n3, int n4, int n5, LatLngBounds latLngBounds, int n6, int n7) {
        int n8;
        int n9;
        if (latLngBounds == null || latLngBounds.northeast == null || latLngBounds.southwest == null) {
            return null;
        }
        if (iMapConfig == null) {
            return null;
        }
        Point point = VirtualEarthProjection.latLongToPixels(latLngBounds.northeast.latitude, latLngBounds.northeast.longitude, 20);
        Point point2 = VirtualEarthProjection.latLongToPixels(latLngBounds.southwest.latitude, latLngBounds.southwest.longitude, 20);
        int n10 = point.x - point2.x;
        int n11 = point2.y - point.y;
        int n12 = n6 - (n2 + n3);
        int n13 = n7 - (n4 + n5);
        if (n10 < 0 && n11 < 0) {
            return null;
        }
        n10 = n10 <= 0 ? 1 : n10;
        n11 = n11 <= 0 ? 1 : n11;
        n12 = n12 <= 0 ? 1 : n12;
        n13 = n13 <= 0 ? 1 : n13;
        Pair<Float, Boolean> pair = es.a(iMapConfig, point.x, point.y, point2.x, point2.y, n12, n13);
        float f2 = ((Float)pair.first).floatValue();
        boolean bl2 = (Boolean)pair.second;
        float f3 = es.a(iMapConfig.getMapZoomScale(), f2, (double)n10);
        float f4 = es.a(iMapConfig.getMapZoomScale(), f2, (double)n11);
        if (f2 >= iMapConfig.getMaxZoomLevel()) {
            n9 = (int)((float)point2.x + ((float)(n3 - n2) + f3) * (float)n10 / (2.0f * f3));
            n8 = (int)((float)point.y + ((float)(n5 - n4) + f4) * (float)n11 / (2.0f * f4));
        } else if (bl2) {
            n9 = (int)((float)point2.x + (float)(n6 / 2 - n2) / f3 * (float)n10);
            n8 = (int)((float)point.y + ((float)(n5 - n4) + f4) * (float)n11 / (2.0f * f4));
        } else {
            n9 = (int)((float)point2.x + ((float)(n3 - n2) + f3) * (float)n10 / (2.0f * f3));
            n8 = (int)((float)point.y + (float)(n7 / 2 - n4) / f4 * (float)n11);
        }
        float f5 = iMapConfig.getAnchorX() - (iMapConfig.getMapWidth() >> 1);
        float f6 = iMapConfig.getAnchorY() - (iMapConfig.getMapHeight() >> 1);
        n9 = (int)((float)n9 + es.a(iMapConfig.getMapZoomScale(), f2, f5));
        n8 = (int)((float)n8 + es.a(iMapConfig.getMapZoomScale(), f2, f6));
        Pair<Float, IPoint> pair2 = new Pair<Float, IPoint>(Float.valueOf(f2), IPoint.obtain(n9, n8));
        return pair2;
    }

    public static double a(float f2, double d2, double d3) {
        double d4 = d3 / (d2 *= (double)f2);
        return 20.0 - Math.log(d4) / Math.log(2.0);
    }

    private static float a(float f2, float f3, double d2) {
        return (float)(d2 / (Math.pow(2.0, 20.0f - f3) * (double)f2));
    }

    private static float a(float f2, float f3, float f4) {
        return (float)((double)f4 * Math.pow(2.0, 20.0f - f3) * (double)f2);
    }

    public static Pair<Float, Boolean> a(IMapConfig iMapConfig, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = iMapConfig.getSZ();
        boolean bl2 = true;
        if (n2 == n4 && n3 == n5) {
            f2 = iMapConfig.getMaxZoomLevel();
        } else {
            float f3 = (float)es.a(iMapConfig.getMapZoomScale(), (double)n7, (double)Math.abs(n5 - n3));
            float f4 = (float)es.a(iMapConfig.getMapZoomScale(), (double)n6, (double)Math.abs(n4 - n2));
            f2 = Math.min(f4, f3);
            bl2 = f2 == f4;
            f2 = Math.min(iMapConfig.getMaxZoomLevel(), Math.max(iMapConfig.getMinZoomLevel(), f2));
        }
        return new Pair<Float, Boolean>(Float.valueOf(f2), bl2);
    }

    public static float b(IMapConfig iMapConfig, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f2 = iMapConfig.getSZ();
        if (n2 != n4 && n3 != n5) {
            float f3 = (float)es.a(iMapConfig.getMapZoomScale(), (double)n7, (double)Math.abs(n5 - n3));
            float f4 = (float)es.a(iMapConfig.getMapZoomScale(), (double)n6, (double)Math.abs(n4 - n2));
            f2 = Math.max(f4, f3);
        }
        return f2;
    }

    public static boolean b(int n2, int n3) {
        if (n2 > 0 && n3 > 0) {
            return true;
        }
        Log.w("3dmap", "the map must have a size");
        return false;
    }

    public static float a(IGLMapState iGLMapState, int n2, int n3, double d2, double d3, int n4) {
        IPoint iPoint = IPoint.obtain();
        VirtualEarthProjection.latLongToPixels(d2, d3, 20, iPoint);
        float f2 = es.a(iGLMapState, n2, n3, iPoint.x, iPoint.y, n4);
        iPoint.recycle();
        return f2;
    }

    public static float a(IGLMapState iGLMapState, int n2, int n3, int n4, int n5, int n6) {
        if (iGLMapState != null) {
            return iGLMapState.calculateMapZoomer(n2, n3, n4, n5, n6);
        }
        return 3.0f;
    }

    public static synchronized int[] a(int n2, int n3, int n4, int n5, IMapConfig iMapConfig, IGLMapState iGLMapState, int n6, int n7) {
        int n8 = iMapConfig.getMapWidth();
        int n9 = iMapConfig.getMapHeight();
        int n10 = iMapConfig.getAnchorX();
        int n11 = iMapConfig.getAnchorY();
        float f2 = es.a(iMapConfig.getMapZoomScale(), iGLMapState.getMapZoomer(), (float)n10);
        float f3 = es.a(iMapConfig.getMapZoomScale(), iGLMapState.getMapZoomer(), (float)(n8 - n10));
        float f4 = es.a(iMapConfig.getMapZoomScale(), iGLMapState.getMapZoomer(), (float)n11);
        float f5 = es.a(iMapConfig.getMapZoomScale(), iGLMapState.getMapZoomer(), (float)(n9 - n11));
        float f6 = (float)n4 + f2;
        float f7 = (float)n2 - f3;
        float f8 = (float)n3 + f4;
        float f9 = (float)n5 - f5;
        int[] nArray = new int[]{(int)Math.max(f6, Math.min((float)n6, f7)), (int)Math.max(f8, Math.min((float)n7, f9))};
        return nArray;
    }

    public static void a(Rect rect) {
        if (rect != null) {
            rect.set(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        }
    }

    public static void b(Rect rect, int n2, int n3) {
        if (rect != null) {
            if (n2 < rect.left) {
                rect.left = n2;
            }
            if (n2 > rect.right) {
                rect.right = n2;
            }
            if (n3 > rect.top) {
                rect.top = n3;
            }
            if (n3 < rect.bottom) {
                rect.bottom = n3;
            }
        }
    }

    public static byte[] a(byte[] byArray, int n2) {
        return es.a(byArray, n2, n2, true);
    }

    public static byte[] a(byte[] byArray, int n2, int n3, boolean bl2) {
        byte[] byArray2 = null;
        try {
            Bitmap bitmap = BitmapFactory.decodeByteArray(byArray, 0, byArray.length);
            Bitmap bitmap2 = bitmap.copy(bitmap.getConfig(), true);
            int n4 = bitmap.getWidth();
            int n5 = bitmap.getHeight();
            for (int i2 = 0; i2 < n4; ++i2) {
                for (int i3 = 0; i3 < n5; ++i3) {
                    if (i2 == 0 || i3 == 0) {
                        if (bl2) continue;
                        bitmap2.setPixel(i2, i3, n3);
                        continue;
                    }
                    bitmap2.setPixel(i2, i3, n2);
                }
            }
            byArray2 = es.c(bitmap2);
            if (byArray2 == null) {
                byArray2 = byArray;
            }
            es.b(bitmap2);
            es.b(bitmap);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            byArray2 = byArray;
        }
        return byArray2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] c(Bitmap bitmap) {
        ByteArrayOutputStream byteArrayOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (Throwable throwable) {
        }
        finally {
            try {
                if (byteArrayOutputStream != null) {
                    byteArrayOutputStream.close();
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return null;
    }

    public static boolean a(List<BaseHoleOptions> list, PolygonHoleOptions polygonHoleOptions) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            BaseHoleOptions baseHoleOptions;
            BaseHoleOptions baseHoleOptions2 = list.get(i2);
            if (baseHoleOptions2 instanceof PolygonHoleOptions) {
                baseHoleOptions = (PolygonHoleOptions)baseHoleOptions2;
                bl2 = es.a(baseHoleOptions.getPoints(), polygonHoleOptions.getPoints());
                if (!bl2) continue;
                return true;
            }
            if (!(baseHoleOptions2 instanceof CircleHoleOptions)) continue;
            baseHoleOptions = (CircleHoleOptions)baseHoleOptions2;
            bl2 = es.b(polygonHoleOptions.getPoints(), (CircleHoleOptions)baseHoleOptions);
            if (!bl2) continue;
            return true;
        }
        return bl2;
    }

    public static boolean a(List<BaseHoleOptions> list, CircleHoleOptions circleHoleOptions) {
        boolean bl2 = false;
        for (int i2 = 0; i2 < list.size(); ++i2) {
            BaseHoleOptions baseHoleOptions;
            BaseHoleOptions baseHoleOptions2 = list.get(i2);
            if (!(baseHoleOptions2 instanceof PolygonHoleOptions ? (bl2 = es.b((baseHoleOptions = (PolygonHoleOptions)baseHoleOptions2).getPoints(), circleHoleOptions)) : baseHoleOptions2 instanceof CircleHoleOptions && (bl2 = es.a(circleHoleOptions, (CircleHoleOptions)(baseHoleOptions = (CircleHoleOptions)baseHoleOptions2))))) continue;
            return true;
        }
        return bl2;
    }

    public static boolean a(CircleHoleOptions circleHoleOptions, CircleHoleOptions circleHoleOptions2) {
        try {
            float f2 = AMapUtils.calculateLineDistance(circleHoleOptions2.getCenter(), circleHoleOptions.getCenter());
            boolean bl2 = (double)f2 < circleHoleOptions.getRadius() + circleHoleOptions2.getRadius();
            return bl2;
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "isPolygon2CircleIntersect");
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean b(List<LatLng> list, CircleHoleOptions circleHoleOptions) {
        try {
            ArrayList<LatLng> arrayList = new ArrayList<LatLng>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                arrayList.add(list.get(i2));
            }
            arrayList.add(list.get(0));
            ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
            for (int i3 = 0; i3 < arrayList.size() && i3 + 1 < arrayList.size(); ++i3) {
                boolean bl2;
                if (circleHoleOptions.getRadius() >= (double)AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), (LatLng)arrayList.get(i3)) || circleHoleOptions.getRadius() >= (double)AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), (LatLng)arrayList.get(i3 + 1))) {
                    return true;
                }
                arrayList2.clear();
                arrayList2.add((LatLng)arrayList.get(i3));
                arrayList2.add((LatLng)arrayList.get(i3 + 1));
                Pair<Integer, LatLng> pair = SpatialRelationUtil.calShortestDistancePoint(arrayList2, circleHoleOptions.getCenter());
                float f2 = AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), (LatLng)pair.second);
                boolean bl3 = bl2 = circleHoleOptions.getRadius() >= (double)f2;
                if (!bl2) continue;
                return true;
            }
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "isPolygon2CircleIntersect");
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean a(List<LatLng> list, List<LatLng> list2) {
        try {
            boolean bl2;
            int n2;
            for (n2 = 0; n2 < list2.size(); ++n2) {
                bl2 = es.a(list2.get(n2), list);
                if (!bl2) continue;
                return true;
            }
            for (n2 = 0; n2 < list.size(); ++n2) {
                bl2 = es.a(list.get(n2), list2);
                if (!bl2) continue;
                return true;
            }
            return es.b(list, list2);
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "isPolygon2PolygonIntersect");
            throwable.printStackTrace();
            return false;
        }
    }

    private static boolean b(List<LatLng> list, List<LatLng> list2) {
        try {
            for (int i2 = 0; i2 < list.size() && i2 + 1 < list.size(); ++i2) {
                for (int i3 = 0; i3 < list2.size() && i3 + 1 < list2.size(); ++i3) {
                    boolean bl2 = en.a(list.get(i2), list.get(i2 + 1), list2.get(i3), list2.get(i3 + 1));
                    if (!bl2) continue;
                    return bl2;
                }
            }
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "isSegmentsIntersect");
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean e(Context context) {
        File file = new File(es.b(context));
        if (!file.exists()) {
            return true;
        }
        return FileUtil.deleteFile(file);
    }

    public static float a(DPoint dPoint, DPoint dPoint2) {
        if (dPoint == null || dPoint2 == null) {
            return 0.0f;
        }
        double d2 = dPoint.x;
        double d3 = dPoint2.x;
        double d4 = dPoint.y;
        double d5 = dPoint2.y;
        float f2 = (float)(Math.atan2(d5 - d4, d3 - d2) / Math.PI * 180.0);
        return f2;
    }

    public static boolean b(List<LatLng> list, PolygonHoleOptions polygonHoleOptions) {
        boolean bl2 = false;
        if (list == null || polygonHoleOptions == null) {
            return bl2;
        }
        try {
            List<LatLng> list2 = polygonHoleOptions.getPoints();
            for (int i2 = 0; i2 < list2.size() && (bl2 = es.a(list2.get(i2), list)); ++i2) {
            }
        }
        catch (Throwable throwable) {
            hd.c(throwable, "PolygonDelegateImp", "isPolygonInPolygon");
            throwable.printStackTrace();
        }
        return bl2;
    }

    public static boolean a(List<LatLng> list, List<BaseHoleOptions> list2, CircleHoleOptions circleHoleOptions) {
        try {
            boolean bl2 = es.b(list, circleHoleOptions);
            if (!bl2 && es.a(list, list2, circleHoleOptions.getCenter())) {
                return true;
            }
        }
        catch (Throwable throwable) {
            hd.c(throwable, "PolygonDelegateImp", "isCircleInPolygon");
            throwable.printStackTrace();
        }
        return false;
    }

    public static boolean a(List<LatLng> list, List<BaseHoleOptions> list2, LatLng latLng) throws RemoteException {
        try {
            if (latLng == null) {
                return false;
            }
            if (list2 != null && list2.size() > 0) {
                for (BaseHoleOptions baseHoleOptions : list2) {
                    if (!es.a(baseHoleOptions, latLng)) continue;
                    return false;
                }
            }
            return es.a(latLng, list);
        }
        catch (Throwable throwable) {
            hd.c(throwable, "PolygonDelegateImp", "contains");
            throwable.printStackTrace();
            return false;
        }
    }

    public static boolean a(double d2, LatLng latLng, List<BaseHoleOptions> list, PolygonHoleOptions polygonHoleOptions) {
        boolean bl2 = true;
        try {
            List<LatLng> list2 = polygonHoleOptions.getPoints();
            for (int i2 = 0; i2 < list2.size() && (bl2 = es.a(d2, latLng, list, list2.get(i2))); ++i2) {
            }
        }
        catch (Throwable throwable) {
            hd.c(throwable, "CircleDelegateImp", "isPolygonInCircle");
            throwable.printStackTrace();
        }
        return bl2;
    }

    public static boolean a(double d2, LatLng latLng, CircleHoleOptions circleHoleOptions) {
        boolean bl2 = true;
        try {
            float f2 = AMapUtils.calculateLineDistance(circleHoleOptions.getCenter(), latLng);
            bl2 = (double)f2 <= d2 - circleHoleOptions.getRadius();
        }
        catch (Throwable throwable) {
            hd.c(throwable, "CircleDelegateImp", "isCircleInCircle");
            throwable.printStackTrace();
        }
        return bl2;
    }

    public static boolean a(double d2, LatLng latLng, List<BaseHoleOptions> list, LatLng latLng2) throws RemoteException {
        if (list != null && list.size() > 0) {
            for (BaseHoleOptions baseHoleOptions : list) {
                if (!es.a(baseHoleOptions, latLng2)) continue;
                return false;
            }
        }
        return d2 >= (double)AMapUtils.calculateLineDistance(latLng, latLng2);
    }

    public static void b(Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        if (Build.VERSION.SDK_INT <= 10 && !bitmap.isRecycled()) {
            bitmap.recycle();
        }
    }

    public static void a(Throwable throwable) {
        try {
            if (MapsInitializer.getExceptionLogger() != null) {
                MapsInitializer.getExceptionLogger().onException(throwable);
            }
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
    }

    public static String a(String string) {
        if (TextUtils.isEmpty(string)) {
            return string;
        }
        try {
            Uri uri = Uri.parse(string);
            if (uri.getAuthority() != null && uri.getAuthority().startsWith("dualstack-")) {
                return string;
            }
            if (uri.getAuthority() != null && uri.getAuthority().startsWith("restsdk.amap.com")) {
                Uri uri2 = uri.buildUpon().authority("dualstack-arestapi.amap.com").build();
                return uri2.toString();
            }
            Uri uri3 = uri.buildUpon().authority("dualstack-" + uri.getAuthority()).build();
            return uri3.toString();
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static Bitmap a(int[] nArray, int n2, int n3) {
        return es.a(nArray, n2, n3, false);
    }

    public static Bitmap a(int[] nArray, int n2, int n3, boolean bl2) {
        Bitmap bitmap = null;
        try {
            int[] nArray2 = nArray;
            int[] nArray3 = new int[nArray2.length];
            for (int i2 = 0; i2 < n3; ++i2) {
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n4 = nArray2[i2 * n2 + i3];
                    int n5 = n4 >> 16 & 0xFF;
                    int n6 = n4 << 16 & 0xFF0000;
                    int n7 = n4 & 0xFF00FF00 | n6 | n5;
                    if (bl2) {
                        nArray3[(n3 - i2 - 1) * n2 + i3] = n7;
                        continue;
                    }
                    nArray3[i2 * n2 + i3] = n7;
                }
            }
            bitmap = Bitmap.createBitmap(n2, n3, Bitmap.Config.ARGB_8888);
            bitmap.setPixels(nArray3, 0, n2, 0, 0, n2, n3);
            return bitmap;
        }
        catch (Throwable throwable) {
            hd.c(throwable, "Util", "rgbaToArgb");
            throwable.printStackTrace();
            return null;
        }
    }

    public static String b(View view) {
        StringBuilder stringBuilder = new StringBuilder();
        try {
            if (view != null) {
                if (view instanceof TextView) {
                    stringBuilder = new StringBuilder(((TextView)view).getText().toString());
                }
                if (view instanceof ViewGroup) {
                    int n2 = ((ViewGroup)view).getChildCount();
                    for (int i2 = 0; i2 < n2; ++i2) {
                        View view2 = ((ViewGroup)view).getChildAt(i2);
                        String string = es.b(view2);
                        if (TextUtils.isEmpty(string)) continue;
                        stringBuilder.append("--");
                        stringBuilder.append(string);
                    }
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return stringBuilder.toString();
    }
}

