/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.graphics.Color;
import com.amap.adapter.util.Log;
import com.amap.api.maps.AMapException;
import java.util.HashMap;

public class Gradient {
    private static final int DEFAULT_COLOR_MAP_SIZE = 1000;
    private int mColorMapSize;
    private int[] mColors;
    private float[] mStartPoints;
    private boolean isAvailable = true;

    public Gradient(int[] nArray, float[] fArray) {
        this(nArray, fArray, 1000);
    }

    private Gradient(int[] nArray, float[] fArray, int n2) {
        try {
            if (nArray == null || fArray == null) {
                throw new AMapException("colors and startPoints should not be null");
            }
            if (nArray.length != fArray.length) {
                throw new AMapException("colors and startPoints should be same length");
            }
            if (nArray.length == 0) {
                throw new AMapException("No colors have been defined");
            }
            for (int i2 = 1; i2 < fArray.length; ++i2) {
                if (!(fArray[i2] < fArray[i2 - 1])) continue;
                throw new AMapException("startPoints should be in increasing order");
            }
            this.mColorMapSize = n2;
            this.mColors = new int[nArray.length];
            this.mStartPoints = new float[fArray.length];
            System.arraycopy(nArray, 0, this.mColors, 0, nArray.length);
            System.arraycopy(fArray, 0, this.mStartPoints, 0, fArray.length);
            this.isAvailable = true;
        }
        catch (AMapException aMapException) {
            this.isAvailable = false;
            Log.e("amap", aMapException.getErrorMessage());
            aMapException.printStackTrace();
        }
    }

    public int[] getColors() {
        return this.mColors;
    }

    public float[] getStartPoints() {
        return this.mStartPoints;
    }

    private HashMap<Integer, a> a() {
        int n2;
        HashMap<Integer, a> hashMap = new HashMap<Integer, a>(32);
        if (this.mStartPoints[0] != 0.0f) {
            n2 = Color.argb(0, Color.red(this.mColors[0]), Color.green(this.mColors[0]), Color.blue(this.mColors[0]));
            hashMap.put(0, new a(n2, this.mColors[0], (float)this.mColorMapSize * this.mStartPoints[0]));
        }
        for (n2 = 1; n2 < this.mColors.length; ++n2) {
            hashMap.put((int)((float)this.mColorMapSize * this.mStartPoints[n2 - 1]), new a(this.mColors[n2 - 1], this.mColors[n2], (float)this.mColorMapSize * (this.mStartPoints[n2] - this.mStartPoints[n2 - 1])));
        }
        if (this.mStartPoints[this.mStartPoints.length - 1] != 1.0f) {
            n2 = this.mStartPoints.length - 1;
            hashMap.put((int)((float)this.mColorMapSize * this.mStartPoints[n2]), new a(this.mColors[n2], this.mColors[n2], (float)this.mColorMapSize * (1.0f - this.mStartPoints[n2])));
        }
        return hashMap;
    }

    protected int[] generateColorMap(double d2) {
        int n2;
        HashMap<Integer, a> hashMap = this.a();
        int[] nArray = new int[this.mColorMapSize];
        a a2 = hashMap.get(0);
        int n3 = 0;
        for (n2 = 0; n2 < this.mColorMapSize; ++n2) {
            if (hashMap.containsKey(n2)) {
                a2 = hashMap.get(n2);
                n3 = n2;
            }
            float f2 = (float)(n2 - n3) / a2.c;
            nArray[n2] = Gradient.a(a2.a, a2.b, f2);
        }
        if (d2 != 1.0) {
            for (n2 = 0; n2 < this.mColorMapSize; ++n2) {
                int n4 = nArray[n2];
                nArray[n2] = Color.argb((int)((double)Color.alpha(n4) * d2), Color.red(n4), Color.green(n4), Color.blue(n4));
            }
        }
        return nArray;
    }

    static int a(int n2, int n3, float f2) {
        int n4 = (int)((float)(Color.alpha(n3) - Color.alpha(n2)) * f2 + (float)Color.alpha(n2));
        float[] fArray = new float[3];
        Color.RGBToHSV(n2, fArray);
        float[] fArray2 = new float[3];
        Color.RGBToHSV(n3, fArray2);
        int n5 = 180;
        int n6 = 360;
        if (fArray[0] - fArray2[0] > (float)n5) {
            fArray2[0] = fArray2[0] + (float)n6;
        } else if (fArray2[0] - fArray[0] > (float)n5) {
            fArray[0] = fArray[0] + (float)n6;
        }
        float[] fArray3 = new float[3];
        int n7 = 3;
        for (int i2 = 0; i2 < n7; ++i2) {
            fArray3[i2] = (fArray2[i2] - fArray[i2]) * f2 + fArray[i2];
        }
        return Color.HSVToColor(n4, fArray3);
    }

    protected boolean isAvailable() {
        return this.isAvailable;
    }

    private static class a {
        private final int a;
        private final int b;
        private final float c;

        private a(int n2, int n3, float f2) {
            this.a = n2;
            this.b = n3;
            this.c = f2;
        }
    }
}

