/*
 * Decompiled with CFR 0.152.
 */
package com.amap.api.maps.model;

import com.amap.adapter.graphics.Typeface;
import com.amap.api.mapcore.util.cx;
import com.amap.api.maps.model.LatLng;
import com.amap.api.maps.model.Marker;
import com.amap.api.maps.model.TextOptions;
import com.autonavi.amap.mapcore.interfaces.IText;

public final class Text {
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER_HORIZONTAL = 4;
    public static final int ALIGN_TOP = 8;
    public static final int ALIGN_BOTTOM = 16;
    public static final int ALIGN_CENTER_VERTICAL = 32;
    private IText textDelegate;
    private Marker marker;
    private TextOptions textOptions;

    public Text(IText iText) {
        this.textDelegate = iText;
    }

    public Text(Marker marker, TextOptions textOptions) {
        this.marker = marker;
        this.textOptions = textOptions;
    }

    public void remove() {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.remove();
            } else {
                this.marker.remove();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void destroy() {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.destroy(true);
            } else {
                this.marker.destroy();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public String getId() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getId();
            }
            return this.marker.getId();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setPosition(LatLng latLng) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setPosition(latLng);
            } else {
                this.marker.setPosition(latLng);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public LatLng getPosition() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getPosition();
            }
            return this.marker.getPosition();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setText(String string) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setText(string);
            } else {
                this.textOptions.text(string);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void a() {
        this.marker.setIcon(cx.b(this.textOptions));
    }

    public String getText() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getText();
            }
            return this.textOptions.getText();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setBackgroundColor(int n2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setBackgroundColor(n2);
            } else {
                this.textOptions.backgroundColor(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getBackgroundColor() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getBackgroundColor();
            }
            return this.textOptions.getBackgroundColor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setFontColor(int n2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setFontColor(n2);
            } else {
                this.textOptions.fontColor(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getFontColor() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getFontColor();
            }
            return this.textOptions.getFontColor();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setFontSize(int n2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setFontSize(n2);
            } else {
                this.textOptions.fontSize(n2);
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getFontSize() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getFontSize();
            }
            return this.textOptions.getFontSize();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public void setTypeface(Typeface typeface) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setTypeface(typeface);
            } else {
                this.textOptions.typeface(typeface);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public Typeface getTypeface() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getTypeface();
            }
            return this.textOptions.getTypeface();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public void setAlign(int n2, int n3) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setAlign(n2, n3);
            } else {
                this.textOptions.align(n2, n3);
                this.marker.setAnchor(cx.a(this.textOptions.getAlignX(), true), cx.a(this.textOptions.getAlignY(), false));
                this.a();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public int getAlignX() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.getAlignX();
            }
            return this.textOptions.getAlignX();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return 0;
        }
    }

    public int getAlignY() {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.getAlignY();
            } else {
                this.textOptions.getAlignY();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return 0;
    }

    public void setVisible(boolean bl2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setVisible(bl2);
            } else {
                this.marker.setVisible(bl2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isVisible() {
        try {
            if (this.textDelegate != null) {
                return this.textDelegate.isVisible();
            }
            return this.marker.isVisible();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public boolean equals(Object object) {
        try {
            if (!(object instanceof Text)) {
                return false;
            }
            if (this.textDelegate != null) {
                return this.textDelegate.equalsRemote(((Text)object).textDelegate);
            }
            return this.marker.equals(((Text)object).marker);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int hashCode() {
        if (this.textDelegate != null) {
            return this.textDelegate.hashCodeRemote();
        }
        return this.marker.hashCode();
    }

    public void setObject(Object object) {
        if (this.textDelegate != null) {
            this.textDelegate.setObject(object);
        } else {
            this.marker.setObject(object);
        }
    }

    public Object getObject() {
        if (this.textDelegate != null) {
            return this.textDelegate.getObject();
        }
        return this.marker.getObject();
    }

    public void setRotate(float f2) {
        try {
            if (this.textDelegate != null) {
                this.textDelegate.setRotateAngle(f2);
            } else {
                this.marker.setRotateAngle(f2);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public float getRotate() {
        if (this.textDelegate != null) {
            return this.textDelegate.getRotateAngle();
        }
        return this.marker.getRotateAngle();
    }

    public void setZIndex(float f2) {
        if (this.textDelegate != null) {
            this.textDelegate.setZIndex(f2);
        } else {
            this.marker.setZIndex(f2);
        }
    }

    public float getZIndex() {
        if (this.textDelegate != null) {
            return this.textDelegate.getZIndex();
        }
        return this.marker.getZIndex();
    }
}

