/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.amap.mapcore.tools;

import com.amap.adapter.content.Context;
import com.amap.adapter.content.pm.PackageInfo;
import com.amap.adapter.content.pm.PackageManager;
import com.amap.adapter.content.res.AssetManager;
import com.amap.adapter.text.TextUtils;
import com.amap.adapter.util.TypedValue;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class GlMapUtil {
    public static final int AMAP_ENGINE_TYPE_DISPLAY_EXTERNAL_1 = 2;
    public static final int AMAP_ENGINE_TYPE_DISPLAY_EXTERNAL_1_EAGLE_EYE = 3;
    public static final int AMAP_ENGINE_TYPE_DISPLAY_EXTERNAL_2 = 4;
    public static final int AMAP_ENGINE_TYPE_DISPLAY_EXTERNAL_2_EAGLE_EYE = 5;
    public static final int AMAP_ENGINE_TYPE_DISPLAY_EXTERNAL_3 = 6;
    public static final int AMAP_ENGINE_TYPE_DISPLAY_EXTERNAL_3_EAGLE_EYE = 7;
    public static final int AN_ENGINE_ID_INVALID = -1;
    public static final int AN_ENGINE_ID_MAIN = 1;
    public static final int AN_ENGINE_ID_EAGLE_EYE = 2;
    public static final int AN_ENGINE_ID_DISPLAY_EXTERNAL_1 = 3;
    public static final int AN_ENGINE_ID_DISPLAY_EXTERNAL_1_EAGLE_EYE = 4;
    public static final int AN_ENGINE_ID_DISPLAY_EXTERNAL_2 = 5;
    public static final int AN_ENGINE_ID_DISPLAY_EXTERNAL_2_EAGLE_EYE = 6;
    public static final int AN_ENGINE_ID_DISPLAY_EXTERNAL_3 = 7;
    public static final int AN_ENGINE_ID_DISPLAY_EXTERNAL_3_EAGLE_EYE = 8;
    public static final int DEVICE_DISPLAY_DPI_LOW = 120;
    public static final int DEVICE_DISPLAY_DPI_NORMAL = 160;
    public static final int DEVICE_DISPLAY_DPI_MEDIAN = 240;
    public static final int DEVICE_DISPLAY_DPI_HIGH = 320;
    public static final int DEVICE_DISPLAY_DPI_XHIGH = 480;
    public static final int DEVICE_DISPLAY_DPI_XXHIGH = 640;

    public static byte[] decodeAssetResData(Context context, String string) {
        AssetManager assetManager = context.getAssets();
        try {
            InputStream inputStream = assetManager.open(string);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = new byte[1024];
            int n2 = -1;
            while ((n2 = inputStream.read(byArray)) > -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.close();
            inputStream.close();
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            return null;
        }
    }

    public static int dipToPixel(Context context, int n2) {
        if (context == null) {
            return n2;
        }
        try {
            float f2 = TypedValue.applyDimension(1, n2, context.getResources().getDisplayMetrics());
            return (int)f2;
        }
        catch (Exception exception) {
            return n2;
        }
    }

    public static int spToPixel(Context context, int n2) {
        float f2 = TypedValue.applyDimension(2, n2, context.getResources().getDisplayMetrics());
        return (int)f2;
    }

    public static String getString(Context context, int n2) {
        return context.getResources().getString(n2);
    }

    public static boolean isAssic(String string) {
        if (TextUtils.isEmpty(string)) {
            return false;
        }
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] < '\u0100' && cArray[i2] > '\u0000') continue;
            return false;
        }
        return true;
    }

    public static String getAppVersionName(Context context) {
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
            return packageInfo.versionName;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return "";
        }
    }
}

