/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.ae.gmap.maploader;

import com.autonavi.ae.gmap.maploader.Pools;

public class ProcessingTile {
    private static final Pools.SynchronizedPool<ProcessingTile> M_POOL = new Pools.SynchronizedPool(30);
    public String mKeyName;
    public long mCreateTime = 0L;

    public static ProcessingTile obtain(String string) {
        ProcessingTile processingTile = M_POOL.acquire();
        if (processingTile != null) {
            processingTile.setParams(string);
        } else {
            processingTile = new ProcessingTile(string);
        }
        return processingTile;
    }

    public void recycle() {
        this.mKeyName = null;
        this.mCreateTime = 0L;
        M_POOL.release(this);
    }

    public ProcessingTile(String string) {
        this.setParams(string);
    }

    private void setParams(String string) {
        this.mKeyName = string;
        this.mCreateTime = System.currentTimeMillis() / 1000L;
    }
}

