/*
 * Decompiled with CFR 0.152.
 */
package com.autonavi.base.amap.mapcore.tools;

import com.amap.adapter.content.Context;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class GLFileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(Context context, String string, File file) throws Exception {
        file.delete();
        InputStream inputStream = context.getAssets().open(string);
        byte[] byArray = new byte[inputStream.available()];
        try {
            inputStream.read(byArray);
        }
        finally {
            GLFileUtil.closeQuietly(inputStream);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            GLFileUtil.closeQuietly(fileOutputStream);
        }
    }

    public static void deleteFile(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = file.listFiles();
        if (file.isDirectory() && fileArray != null) {
            int n2 = fileArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                GLFileUtil.deleteFile(fileArray[i2]);
            }
        }
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void writeDatasToFile(String string, byte[] byArray) {
        block8: {
            FileOutputStream fileOutputStream;
            ReentrantReadWriteLock.WriteLock writeLock;
            block7: {
                ReentrantReadWriteLock reentrantReadWriteLock = new ReentrantReadWriteLock();
                writeLock = reentrantReadWriteLock.writeLock();
                writeLock.lock();
                fileOutputStream = null;
                if (byArray != null && byArray.length != 0) break block7;
                writeLock.unlock();
                GLFileUtil.closeQuietly(fileOutputStream);
                return;
            }
            try {
                File file = new File(string);
                File file2 = file.getParentFile();
                if (!file2.exists()) {
                    file2.mkdirs();
                }
                if (file.exists()) {
                    file.delete();
                }
                file.createNewFile();
                fileOutputStream = new FileOutputStream(file);
                ((OutputStream)fileOutputStream).write(byArray);
                fileOutputStream.flush();
                writeLock.unlock();
            }
            catch (Exception exception) {
                writeLock.unlock();
                GLFileUtil.closeQuietly(fileOutputStream);
                break block8;
                catch (Throwable throwable) {
                    writeLock.unlock();
                    GLFileUtil.closeQuietly(fileOutputStream);
                    throw throwable;
                }
            }
            GLFileUtil.closeQuietly(fileOutputStream);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileContents(String string) {
        block6: {
            byte[] byArray;
            File file;
            FileInputStream fileInputStream;
            block5: {
                fileInputStream = null;
                file = new File(string);
                if (file.exists()) break block5;
                byte[] byArray2 = null;
                GLFileUtil.closeQuietly(fileInputStream);
                return byArray2;
            }
            try {
                fileInputStream = new FileInputStream(file);
                byte[] byArray3 = new byte[1024];
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                int n2 = 0;
                while ((n2 = fileInputStream.read(byArray3)) != -1) {
                    byteArrayOutputStream.write(byArray3, 0, n2);
                }
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            catch (Exception exception) {
                GLFileUtil.closeQuietly(fileInputStream);
                break block6;
            }
            catch (Throwable throwable) {
                GLFileUtil.closeQuietly(fileInputStream);
                throw throwable;
            }
            GLFileUtil.closeQuietly(fileInputStream);
            return byArray;
        }
        return null;
    }

    public static File getCacheDir(Context context) {
        File file = context.getCacheDir();
        if (file == null) {
            file = context.getDir("cache", 0);
        }
        if (file == null) {
            file = new File("/data/data/" + context.getPackageName() + "/app_cache");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static File getFilesDir(Context context) {
        File file = context.getFilesDir();
        if (file == null) {
            file = context.getDir("files", 0);
        }
        if (file == null) {
            file = new File("/data/data/" + context.getPackageName() + "/app_files");
        }
        if (!file.exists()) {
            file.mkdirs();
        }
        return file;
    }
}

